// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Graphics.pas' rev: 10.00

#ifndef GraphicsHPP
#define GraphicsHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------
namespace Graphics
{
  enum TColor {clMin=-0x7fffffff-1, clMax=0x7fffffff};
}
namespace Graphics
{
  enum TFontStyle { fsBold, fsItalic, fsUnderline, fsStrikeOut };
  typedef SmallStringBase<31> TFontDataName;
  typedef SetBase<TFontStyle, fsBold, fsStrikeOut> TFontStylesBase;
}

namespace Graphics
{
//-- type declarations -------------------------------------------------------
typedef TColor *PColor;

struct TCursorOrIcon;
typedef TCursorOrIcon *PCursorOrIcon;

#pragma pack(push,1)
struct TCursorOrIcon
{
	
public:
	Word Reserved;
	Word wType;
	Word Count;
} ;
#pragma pack(pop)

struct TIconRec;
typedef TIconRec *PIconRec;

#pragma pack(push,1)
struct TIconRec
{
	
public:
	Byte Width;
	Byte Height;
	Word Colors;
	Word Reserved1;
	Word Reserved2;
	int DIBSize;
	int DIBOffset;
} ;
#pragma pack(pop)

class DELPHICLASS EInvalidGraphic;
class PASCALIMPLEMENTATION EInvalidGraphic : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EInvalidGraphic(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInvalidGraphic(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInvalidGraphic(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInvalidGraphic(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInvalidGraphic(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInvalidGraphic(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInvalidGraphic(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInvalidGraphic(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInvalidGraphic(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInvalidGraphicOperation;
class PASCALIMPLEMENTATION EInvalidGraphicOperation : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EInvalidGraphicOperation(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInvalidGraphicOperation(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInvalidGraphicOperation(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInvalidGraphicOperation(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInvalidGraphicOperation(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInvalidGraphicOperation(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInvalidGraphicOperation(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInvalidGraphicOperation(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInvalidGraphicOperation(void) { }
	#pragma option pop
	
};


struct TResData
{
	
public:
	unsigned Handle;
} ;

#pragma option push -b-
enum TFontPitch { fpDefault, fpVariable, fpFixed };
#pragma option pop

typedef AnsiString TFontName;

typedef Byte TFontCharset;

typedef Set<TFontStyle, fsBold, fsStrikeOut>  TFontStyles;

struct TFontData
{
	
public:
	HFONT Handle;
	int Height;
	int Orientation;
	TFontPitch Pitch;
	TFontStylesBase Style;
	TFontCharset Charset;
	TFontDataName Name;
} ;

#pragma option push -b-
enum TPenStyle { psSolid, psDash, psDot, psDashDot, psDashDotDot, psClear, psInsideFrame, psUserStyle, psAlternate };
#pragma option pop

#pragma option push -b-
enum TPenMode { pmBlack, pmWhite, pmNop, pmNot, pmCopy, pmNotCopy, pmMergePenNot, pmMaskPenNot, pmMergeNotPen, pmMaskNotPen, pmMerge, pmNotMerge, pmMask, pmNotMask, pmXor, pmNotXor };
#pragma option pop

struct TPenData
{
	
public:
	HPEN Handle;
	TColor Color;
	int Width;
	TPenStyle Style;
} ;

#pragma option push -b-
enum TBrushStyle { bsSolid, bsClear, bsHorizontal, bsVertical, bsFDiagonal, bsBDiagonal, bsCross, bsDiagCross };
#pragma option pop

class DELPHICLASS TBitmap;
class DELPHICLASS TGraphic;
#pragma option push -b-
enum TProgressStage { psStarting, psRunning, psEnding };
#pragma option pop

typedef void __fastcall (__closure *TProgressEvent)(System::TObject* Sender, TProgressStage Stage, Byte PercentDone, bool RedrawNow, const Types::TRect &R, const AnsiString Msg);

class DELPHICLASS TCanvas;
class PASCALIMPLEMENTATION TGraphic : public Classes::TInterfacedPersistent 
{
	typedef Classes::TInterfacedPersistent inherited;
	
private:
	Classes::TNotifyEvent FOnChange;
	TProgressEvent FOnProgress;
	bool FModified;
	bool FTransparent;
	bool FPaletteModified;
	void __fastcall SetModified(bool Value);
	
protected:
	virtual void __fastcall Changed(System::TObject* Sender);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual void __fastcall Draw(TCanvas* ACanvas, const Types::TRect &Rect) = 0 ;
	virtual bool __fastcall Equals(TGraphic* Graphic);
	virtual bool __fastcall GetEmpty(void) = 0 ;
	virtual int __fastcall GetHeight(void) = 0 ;
	virtual HPALETTE __fastcall GetPalette(void);
	virtual bool __fastcall GetTransparent(void);
	virtual int __fastcall GetWidth(void) = 0 ;
	DYNAMIC void __fastcall Progress(System::TObject* Sender, TProgressStage Stage, Byte PercentDone, bool RedrawNow, const Types::TRect &R, const AnsiString Msg);
	virtual void __fastcall ReadData(Classes::TStream* Stream);
	virtual void __fastcall SetHeight(int Value) = 0 ;
	virtual void __fastcall SetPalette(HPALETTE Value);
	virtual void __fastcall SetTransparent(bool Value);
	virtual void __fastcall SetWidth(int Value) = 0 ;
	virtual void __fastcall WriteData(Classes::TStream* Stream);
	
public:
	__fastcall virtual TGraphic(void);
	virtual void __fastcall LoadFromFile(const AnsiString Filename);
	virtual void __fastcall SaveToFile(const AnsiString Filename);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream) = 0 ;
	virtual void __fastcall SaveToStream(Classes::TStream* Stream) = 0 ;
	virtual void __fastcall LoadFromClipboardFormat(Word AFormat, unsigned AData, HPALETTE APalette) = 0 ;
	virtual void __fastcall SaveToClipboardFormat(Word &AFormat, unsigned &AData, HPALETTE &APalette) = 0 ;
	virtual void __fastcall SetSize(int AWidth, int AHeight);
	__property bool Empty = {read=GetEmpty, nodefault};
	__property int Height = {read=GetHeight, write=SetHeight, nodefault};
	__property bool Modified = {read=FModified, write=SetModified, nodefault};
	__property HPALETTE Palette = {read=GetPalette, write=SetPalette, nodefault};
	__property bool PaletteModified = {read=FPaletteModified, write=FPaletteModified, nodefault};
	__property bool Transparent = {read=GetTransparent, write=SetTransparent, nodefault};
	__property int Width = {read=GetWidth, write=SetWidth, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property TProgressEvent OnProgress = {read=FOnProgress, write=FOnProgress};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TGraphic(void) { }
	#pragma option pop
	
private:
	void *__IStreamPersist;	/* Classes::IStreamPersist */
	
public:
	operator IStreamPersist*(void) { return (IStreamPersist*)&__IStreamPersist; }
	
};


class DELPHICLASS TBitmapImage;
class DELPHICLASS TSharedImage;
class PASCALIMPLEMENTATION TSharedImage : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FRefCount;
	
protected:
	void __fastcall Reference(void);
	void __fastcall Release(void);
	virtual void __fastcall FreeHandle(void) = 0 ;
	__property int RefCount = {read=FRefCount, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TSharedImage(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TSharedImage(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TBitmapImage : public TSharedImage 
{
	typedef TSharedImage inherited;
	
private:
	HBITMAP FHandle;
	HBITMAP FMaskHandle;
	HPALETTE FPalette;
	HBITMAP FDIBHandle;
	#pragma pack(push,1)
	tagDIBSECTION FDIB;
	#pragma pack(pop)
	Classes::TMemoryStream* FSaveStream;
	bool FOS2Format;
	bool FHalftone;
	
protected:
	virtual void __fastcall FreeHandle(void);
	
public:
	__fastcall virtual ~TBitmapImage(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TBitmapImage(void) : TSharedImage() { }
	#pragma option pop
	
};


#pragma option push -b-
enum TTransparentMode { tmAuto, tmFixed };
#pragma option pop

#pragma option push -b-
enum TBitmapHandleType { bmDIB, bmDDB };
#pragma option pop

#pragma option push -b-
enum TPixelFormat { pfDevice, pf1bit, pf4bit, pf8bit, pf15bit, pf16bit, pf24bit, pf32bit, pfCustom };
#pragma option pop

class PASCALIMPLEMENTATION TBitmap : public TGraphic 
{
	typedef TGraphic inherited;
	
private:
	TBitmapImage* FImage;
	TCanvas* FCanvas;
	bool FIgnorePalette;
	bool FMaskBitsValid;
	bool FMaskValid;
	TColor FTransparentColor;
	TTransparentMode FTransparentMode;
	void __fastcall Changing(System::TObject* Sender);
	void __fastcall CopyImage(HBITMAP AHandle, HPALETTE APalette, const tagDIBSECTION &DIB);
	void __fastcall DIBNeeded(void);
	void __fastcall FreeContext(void);
	TCanvas* __fastcall GetCanvas(void);
	virtual HBITMAP __fastcall GetHandle(void);
	TBitmapHandleType __fastcall GetHandleType(void);
	virtual HBITMAP __fastcall GetMaskHandle(void);
	bool __fastcall GetMonochrome(void);
	TPixelFormat __fastcall GetPixelFormat(void);
	void * __fastcall GetScanline(int Row);
	TColor __fastcall GetTransparentColor(void);
	void __fastcall NewImage(HBITMAP NewHandle, HPALETTE NewPalette, const tagDIBSECTION &NewDIB, bool OS2Format, Classes::TStream* RLEStream = (Classes::TStream*)(0x0));
	void __fastcall ReadStream(Classes::TStream* Stream, int Size);
	void __fastcall ReadDIB(Classes::TStream* Stream, unsigned ImageSize, Windows::PBitmapFileHeader bmf = (void *)(0x0));
	void __fastcall SetHandle(HBITMAP Value);
	virtual void __fastcall SetHandleType(TBitmapHandleType Value);
	void __fastcall SetMaskHandle(HBITMAP Value);
	void __fastcall SetMonochrome(bool Value);
	void __fastcall SetPixelFormat(TPixelFormat Value);
	void __fastcall SetTransparentColor(TColor Value);
	void __fastcall SetTransparentMode(TTransparentMode Value);
	bool __fastcall TransparentColorStored(void);
	void __fastcall WriteStream(Classes::TStream* Stream, bool WriteSize);
	
protected:
	virtual void __fastcall Changed(System::TObject* Sender);
	virtual void __fastcall Draw(TCanvas* ACanvas, const Types::TRect &Rect);
	virtual bool __fastcall GetEmpty(void);
	virtual int __fastcall GetHeight(void);
	virtual HPALETTE __fastcall GetPalette(void);
	virtual int __fastcall GetWidth(void);
	void __fastcall HandleNeeded(void);
	void __fastcall MaskHandleNeeded(void);
	void __fastcall PaletteNeeded(void);
	virtual void __fastcall ReadData(Classes::TStream* Stream);
	virtual void __fastcall SetHeight(int Value);
	virtual void __fastcall SetPalette(HPALETTE Value);
	virtual void __fastcall SetWidth(int Value);
	virtual void __fastcall WriteData(Classes::TStream* Stream);
	
public:
	__fastcall virtual TBitmap(void);
	__fastcall virtual ~TBitmap(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall Dormant(void);
	void __fastcall FreeImage(void);
	bool __fastcall HandleAllocated(void);
	virtual void __fastcall LoadFromClipboardFormat(Word AFormat, unsigned AData, HPALETTE APalette);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall LoadFromResourceName(unsigned Instance, const AnsiString ResName);
	void __fastcall LoadFromResourceID(unsigned Instance, int ResID);
	void __fastcall Mask(TColor TransparentColor);
	HBITMAP __fastcall ReleaseHandle(void);
	HBITMAP __fastcall ReleaseMaskHandle(void);
	HPALETTE __fastcall ReleasePalette(void);
	virtual void __fastcall SaveToClipboardFormat(Word &Format, unsigned &Data, HPALETTE &APalette);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SetSize(int AWidth, int AHeight);
	__property TCanvas* Canvas = {read=GetCanvas};
	__property HBITMAP Handle = {read=GetHandle, write=SetHandle, nodefault};
	__property TBitmapHandleType HandleType = {read=GetHandleType, write=SetHandleType, nodefault};
	__property bool IgnorePalette = {read=FIgnorePalette, write=FIgnorePalette, nodefault};
	__property HBITMAP MaskHandle = {read=GetMaskHandle, write=SetMaskHandle, nodefault};
	__property bool Monochrome = {read=GetMonochrome, write=SetMonochrome, nodefault};
	__property TPixelFormat PixelFormat = {read=GetPixelFormat, write=SetPixelFormat, nodefault};
	__property void * ScanLine[int Row] = {read=GetScanline};
	__property TColor TransparentColor = {read=GetTransparentColor, write=SetTransparentColor, stored=TransparentColorStored, nodefault};
	__property TTransparentMode TransparentMode = {read=FTransparentMode, write=SetTransparentMode, default=0};
};


struct TBrushData
{
	
public:
	HBRUSH Handle;
	TColor Color;
	TBitmap* Bitmap;
	TBrushStyle Style;
	bool OwnsBitmap;
} ;

struct TResource;
typedef TResource *PResource;

struct TResource
{
	
public:
	TResource *Next;
	int RefCount;
	unsigned Handle;
	Word HashCode;
	union
	{
		struct 
		{
			TBrushData Brush;
			
		};
		struct 
		{
			TPenData Pen;
			
		};
		struct 
		{
			TFontData Font;
			
		};
		struct 
		{
			TResData Data;
			
		};
		
	};
} ;

class DELPHICLASS TGraphicsObject;
class PASCALIMPLEMENTATION TGraphicsObject : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Classes::TNotifyEvent FOnChange;
	TResource *FResource;
	_RTL_CRITICAL_SECTION *FOwnerLock;
	
protected:
	DYNAMIC void __fastcall Changed(void);
	void __fastcall Lock(void);
	void __fastcall Unlock(void);
	
public:
	bool __fastcall HandleAllocated(void);
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property Windows::PRTLCriticalSection OwnerCriticalSection = {read=FOwnerLock, write=FOwnerLock};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TGraphicsObject(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TGraphicsObject(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


__interface IChangeNotifier;
typedef System::DelphiInterface<IChangeNotifier> _di_IChangeNotifier;
__interface  INTERFACE_UUID("{1FB62321-44A7-11D0-9E93-0020AF3D82DA}") IChangeNotifier  : public IInterface 
{
	
public:
	virtual void __fastcall Changed(void) = 0 ;
};

class DELPHICLASS TFont;
class PASCALIMPLEMENTATION TFont : public TGraphicsObject 
{
	typedef TGraphicsObject inherited;
	
private:
	TColor FColor;
	int FPixelsPerInch;
	_di_IChangeNotifier FNotify;
	void __fastcall GetData(TFontData &FontData);
	void __fastcall SetData(const TFontData &FontData);
	
protected:
	DYNAMIC void __fastcall Changed(void);
	HFONT __fastcall GetHandle(void);
	int __fastcall GetHeight(void);
	AnsiString __fastcall GetName();
	int __fastcall GetOrientation(void);
	TFontPitch __fastcall GetPitch(void);
	int __fastcall GetSize(void);
	TFontStyles __fastcall GetStyle(void);
	TFontCharset __fastcall GetCharset(void);
	void __fastcall SetColor(const TColor Value);
	void __fastcall SetHandle(const HFONT Value);
	void __fastcall SetHeight(const int Value);
	void __fastcall SetOrientation(const int Value);
	void __fastcall SetName(const AnsiString Value);
	void __fastcall SetPitch(const TFontPitch Value);
	void __fastcall SetSize(const int Value);
	void __fastcall SetStyle(const TFontStyles Value);
	void __fastcall SetCharset(const TFontCharset Value);
	
public:
	__fastcall TFont(void);
	__fastcall virtual ~TFont(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property _di_IChangeNotifier FontAdapter = {read=FNotify, write=FNotify};
	__property HFONT Handle = {read=GetHandle, write=SetHandle, nodefault};
	__property int PixelsPerInch = {read=FPixelsPerInch, write=FPixelsPerInch, nodefault};
	
__published:
	__property TFontCharset Charset = {read=GetCharset, write=SetCharset, nodefault};
	__property TColor Color = {read=FColor, write=SetColor, nodefault};
	__property int Height = {read=GetHeight, write=SetHeight, nodefault};
	__property AnsiString Name = {read=GetName, write=SetName};
	__property int Orientation = {read=GetOrientation, write=SetOrientation, default=0};
	__property TFontPitch Pitch = {read=GetPitch, write=SetPitch, default=0};
	__property int Size = {read=GetSize, write=SetSize, stored=false, nodefault};
	__property TFontStyles Style = {read=GetStyle, write=SetStyle, nodefault};
};


class DELPHICLASS TPen;
class PASCALIMPLEMENTATION TPen : public TGraphicsObject 
{
	typedef TGraphicsObject inherited;
	
private:
	TPenMode FMode;
	void __fastcall GetData(TPenData &PenData);
	void __fastcall SetData(const TPenData &PenData);
	
protected:
	TColor __fastcall GetColor(void);
	void __fastcall SetColor(TColor Value);
	HPEN __fastcall GetHandle(void);
	void __fastcall SetHandle(HPEN Value);
	void __fastcall SetMode(TPenMode Value);
	TPenStyle __fastcall GetStyle(void);
	void __fastcall SetStyle(TPenStyle Value);
	int __fastcall GetWidth(void);
	void __fastcall SetWidth(int Value);
	
public:
	__fastcall TPen(void);
	__fastcall virtual ~TPen(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property HPEN Handle = {read=GetHandle, write=SetHandle, nodefault};
	
__published:
	__property TColor Color = {read=GetColor, write=SetColor, default=0};
	__property TPenMode Mode = {read=FMode, write=SetMode, default=4};
	__property TPenStyle Style = {read=GetStyle, write=SetStyle, default=0};
	__property int Width = {read=GetWidth, write=SetWidth, default=1};
};


class DELPHICLASS TBrush;
class PASCALIMPLEMENTATION TBrush : public TGraphicsObject 
{
	typedef TGraphicsObject inherited;
	
private:
	void __fastcall GetData(TBrushData &BrushData);
	void __fastcall SetData(const TBrushData &BrushData);
	
protected:
	TBitmap* __fastcall GetBitmap(void);
	void __fastcall SetBitmap(TBitmap* Value);
	TColor __fastcall GetColor(void);
	void __fastcall SetColor(TColor Value);
	HBRUSH __fastcall GetHandle(void);
	void __fastcall SetHandle(HBRUSH Value);
	TBrushStyle __fastcall GetStyle(void);
	void __fastcall SetStyle(TBrushStyle Value);
	
public:
	__fastcall TBrush(void);
	__fastcall virtual ~TBrush(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property TBitmap* Bitmap = {read=GetBitmap, write=SetBitmap};
	__property HBRUSH Handle = {read=GetHandle, write=SetHandle, nodefault};
	
__published:
	__property TColor Color = {read=GetColor, write=SetColor, default=16777215};
	__property TBrushStyle Style = {read=GetStyle, write=SetStyle, default=0};
};


class DELPHICLASS TFontRecall;
class PASCALIMPLEMENTATION TFontRecall : public Classes::TRecall 
{
	typedef Classes::TRecall inherited;
	
public:
	__fastcall TFontRecall(TFont* AFont);
public:
	#pragma option push -w-inl
	/* TRecall.Destroy */ inline __fastcall virtual ~TFontRecall(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPenRecall;
class PASCALIMPLEMENTATION TPenRecall : public Classes::TRecall 
{
	typedef Classes::TRecall inherited;
	
public:
	__fastcall TPenRecall(TPen* APen);
public:
	#pragma option push -w-inl
	/* TRecall.Destroy */ inline __fastcall virtual ~TPenRecall(void) { }
	#pragma option pop
	
};


class DELPHICLASS TBrushRecall;
class PASCALIMPLEMENTATION TBrushRecall : public Classes::TRecall 
{
	typedef Classes::TRecall inherited;
	
public:
	__fastcall TBrushRecall(TBrush* ABrush);
public:
	#pragma option push -w-inl
	/* TRecall.Destroy */ inline __fastcall virtual ~TBrushRecall(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TFillStyle { fsSurface, fsBorder };
#pragma option pop

#pragma option push -b-
enum TFillMode { fmAlternate, fmWinding };
#pragma option pop

typedef int TCopyMode;

#pragma option push -b-
enum TCanvasStates { csHandleValid, csFontValid, csPenValid, csBrushValid };
#pragma option pop

typedef Set<TCanvasStates, csHandleValid, csBrushValid>  TCanvasState;

#pragma option push -b-
enum TCanvasOrientation { coLeftToRight, coRightToLeft };
#pragma option pop

#pragma option push -b-
enum TTextFormats { tfBottom, tfCalcRect, tfCenter, tfEditControl, tfEndEllipsis, tfPathEllipsis, tfExpandTabs, tfExternalLeading, tfLeft, tfModifyString, tfNoClip, tfNoPrefix, tfRight, tfRtlReading, tfSingleLine, tfTop, tfVerticalCenter, tfWordBreak };
#pragma option pop

typedef Set<TTextFormats, tfBottom, tfWordBreak>  TTextFormat;

class PASCALIMPLEMENTATION TCanvas : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	HDC FHandle;
	TCanvasState State;
	TFont* FFont;
	TPen* FPen;
	TBrush* FBrush;
	#pragma pack(push,1)
	Types::TPoint FPenPos;
	#pragma pack(pop)
	int FCopyMode;
	Classes::TNotifyEvent FOnChange;
	Classes::TNotifyEvent FOnChanging;
	_RTL_CRITICAL_SECTION FLock;
	int FLockCount;
	int FTextFlags;
	void __fastcall CreateBrush(void);
	void __fastcall CreateFont(void);
	void __fastcall CreatePen(void);
	void __fastcall BrushChanged(System::TObject* ABrush);
	void __fastcall DeselectHandles(void);
	TCanvasOrientation __fastcall GetCanvasOrientation(void);
	Types::TRect __fastcall GetClipRect();
	HDC __fastcall GetHandle(void);
	Types::TPoint __fastcall GetPenPos();
	TColor __fastcall GetPixel(int X, int Y);
	void __fastcall FontChanged(System::TObject* AFont);
	void __fastcall PenChanged(System::TObject* APen);
	void __fastcall SetBrush(TBrush* Value);
	void __fastcall SetFont(TFont* Value);
	void __fastcall SetHandle(HDC Value);
	void __fastcall SetPen(TPen* Value);
	void __fastcall SetPenPos(const Types::TPoint &Value);
	void __fastcall SetPixel(int X, int Y, TColor Value);
	
protected:
	virtual void __fastcall Changed(void);
	virtual void __fastcall Changing(void);
	virtual void __fastcall CreateHandle(void);
	void __fastcall RequiredState(TCanvasState ReqState);
	
public:
	__fastcall TCanvas(void);
	__fastcall virtual ~TCanvas(void);
	void __fastcall Arc(int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4);
	void __fastcall BrushCopy(const Types::TRect &Dest, TBitmap* Bitmap, const Types::TRect &Source, TColor Color);
	void __fastcall Chord(int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4);
	void __fastcall CopyRect(const Types::TRect &Dest, TCanvas* Canvas, const Types::TRect &Source);
	void __fastcall Draw(int X, int Y, TGraphic* Graphic);
	void __fastcall DrawFocusRect(const Types::TRect &Rect);
	void __fastcall Ellipse(int X1, int Y1, int X2, int Y2)/* overload */;
	void __fastcall Ellipse(const Types::TRect &Rect)/* overload */;
	void __fastcall FillRect(const Types::TRect &Rect);
	void __fastcall FloodFill(int X, int Y, TColor Color, TFillStyle FillStyle);
	void __fastcall FrameRect(const Types::TRect &Rect);
	bool __fastcall HandleAllocated(void);
	void __fastcall LineTo(int X, int Y);
	void __fastcall Lock(void);
	void __fastcall MoveTo(int X, int Y);
	void __fastcall Pie(int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4);
	void __fastcall Polygon(Types::TPoint const * Points, const int Points_Size);
	void __fastcall Polyline(Types::TPoint const * Points, const int Points_Size);
	void __fastcall PolyBezier(Types::TPoint const * Points, const int Points_Size);
	void __fastcall PolyBezierTo(Types::TPoint const * Points, const int Points_Size);
	void __fastcall Rectangle(int X1, int Y1, int X2, int Y2)/* overload */;
	void __fastcall Rectangle(const Types::TRect &Rect)/* overload */;
	void __fastcall Refresh(void);
	void __fastcall RoundRect(int X1, int Y1, int X2, int Y2, int X3, int Y3);
	void __fastcall StretchDraw(const Types::TRect &Rect, TGraphic* Graphic);
	tagSIZE __fastcall TextExtent(const AnsiString Text);
	int __fastcall TextHeight(const AnsiString Text);
	void __fastcall TextOut(int X, int Y, const AnsiString Text);
	void __fastcall TextRect(const Types::TRect &Rect, int X, int Y, const AnsiString Text)/* overload */;
	void __fastcall TextRect(Types::TRect &Rect, AnsiString &Text, TTextFormat TextFormat = Set<TTextFormats, tfBottom, tfWordBreak> () )/* overload */;
	int __fastcall TextWidth(const AnsiString Text);
	bool __fastcall TryLock(void);
	void __fastcall Unlock(void);
	__property Types::TRect ClipRect = {read=GetClipRect};
	__property HDC Handle = {read=GetHandle, write=SetHandle, nodefault};
	__property int LockCount = {read=FLockCount, nodefault};
	__property TCanvasOrientation CanvasOrientation = {read=GetCanvasOrientation, nodefault};
	__property Types::TPoint PenPos = {read=GetPenPos, write=SetPenPos};
	__property TColor Pixels[int X][int Y] = {read=GetPixel, write=SetPixel};
	__property int TextFlags = {read=FTextFlags, write=FTextFlags, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property Classes::TNotifyEvent OnChanging = {read=FOnChanging, write=FOnChanging};
	
__published:
	__property TBrush* Brush = {read=FBrush, write=SetBrush};
	__property int CopyMode = {read=FCopyMode, write=FCopyMode, default=13369376};
	__property TFont* Font = {read=FFont, write=SetFont};
	__property TPen* Pen = {read=FPen, write=SetPen};
};


typedef TMetaClass* TGraphicClass;

class DELPHICLASS TPicture;
class DELPHICLASS TIcon;
class DELPHICLASS TMetafile;
class PASCALIMPLEMENTATION TPicture : public Classes::TInterfacedPersistent 
{
	typedef Classes::TInterfacedPersistent inherited;
	
private:
	TGraphic* FGraphic;
	Classes::TNotifyEvent FOnChange;
	_di_IChangeNotifier FNotify;
	TProgressEvent FOnProgress;
	void __fastcall ForceType(TMetaClass* GraphicType);
	TBitmap* __fastcall GetBitmap(void);
	int __fastcall GetHeight(void);
	TIcon* __fastcall GetIcon(void);
	TMetafile* __fastcall GetMetafile(void);
	int __fastcall GetWidth(void);
	void __fastcall ReadData(Classes::TStream* Stream);
	void __fastcall SetBitmap(TBitmap* Value);
	void __fastcall SetGraphic(TGraphic* Value);
	void __fastcall SetIcon(TIcon* Value);
	void __fastcall SetMetafile(TMetafile* Value);
	void __fastcall WriteData(Classes::TStream* Stream);
	
protected:
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	DYNAMIC void __fastcall Changed(System::TObject* Sender);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	DYNAMIC void __fastcall Progress(System::TObject* Sender, TProgressStage Stage, Byte PercentDone, bool RedrawNow, const Types::TRect &R, const AnsiString Msg);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	
public:
	__fastcall TPicture(void);
	__fastcall virtual ~TPicture(void);
	void __fastcall LoadFromFile(const AnsiString Filename);
	void __fastcall SaveToFile(const AnsiString Filename);
	void __fastcall LoadFromClipboardFormat(Word AFormat, unsigned AData, HPALETTE APalette);
	void __fastcall SaveToClipboardFormat(Word &AFormat, unsigned &AData, HPALETTE &APalette);
	/*         class method */ static bool __fastcall SupportsClipboardFormat(TMetaClass* vmt, Word AFormat);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	/*         class method */ static void __fastcall RegisterFileFormat(TMetaClass* vmt, const AnsiString AExtension, const AnsiString ADescription, TMetaClass* AGraphicClass);
	/*         class method */ static void __fastcall RegisterFileFormatRes(TMetaClass* vmt, const AnsiString AExtension, int ADescriptionResID, TMetaClass* AGraphicClass);
	/*         class method */ static void __fastcall RegisterClipboardFormat(TMetaClass* vmt, Word AFormat, TMetaClass* AGraphicClass);
	/*         class method */ static void __fastcall UnregisterGraphicClass(TMetaClass* vmt, TMetaClass* AClass);
	__property TBitmap* Bitmap = {read=GetBitmap, write=SetBitmap};
	__property TGraphic* Graphic = {read=FGraphic, write=SetGraphic};
	__property _di_IChangeNotifier PictureAdapter = {read=FNotify, write=FNotify};
	__property int Height = {read=GetHeight, nodefault};
	__property TIcon* Icon = {read=GetIcon, write=SetIcon};
	__property TMetafile* Metafile = {read=GetMetafile, write=SetMetafile};
	__property int Width = {read=GetWidth, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property TProgressEvent OnProgress = {read=FOnProgress, write=FOnProgress};
private:
	void *__IStreamPersist;	/* Classes::IStreamPersist */
	
public:
	operator IStreamPersist*(void) { return (IStreamPersist*)&__IStreamPersist; }
	
};


class DELPHICLASS TMetafileCanvas;
class PASCALIMPLEMENTATION TMetafileCanvas : public TCanvas 
{
	typedef TCanvas inherited;
	
private:
	TMetafile* FMetafile;
	
public:
	__fastcall TMetafileCanvas(TMetafile* AMetafile, HDC ReferenceDevice);
	__fastcall TMetafileCanvas(TMetafile* AMetafile, HDC ReferenceDevice, const AnsiString CreatedBy, const AnsiString Description);
	__fastcall virtual ~TMetafileCanvas(void);
};


class DELPHICLASS TMetafileImage;
class PASCALIMPLEMENTATION TMetafileImage : public TSharedImage 
{
	typedef TSharedImage inherited;
	
private:
	unsigned FHandle;
	int FWidth;
	int FHeight;
	HPALETTE FPalette;
	Word FInch;
	int FTempWidth;
	int FTempHeight;
	
protected:
	virtual void __fastcall FreeHandle(void);
	
public:
	__fastcall virtual ~TMetafileImage(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TMetafileImage(void) : TSharedImage() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TMetafile : public TGraphic 
{
	typedef TGraphic inherited;
	
private:
	TMetafileImage* FImage;
	bool FEnhanced;
	AnsiString __fastcall GetAuthor();
	AnsiString __fastcall GetDesc();
	unsigned __fastcall GetHandle(void);
	Word __fastcall GetInch(void);
	int __fastcall GetMMHeight(void);
	int __fastcall GetMMWidth(void);
	void __fastcall NewImage(void);
	void __fastcall SetHandle(unsigned Value);
	void __fastcall SetInch(Word Value);
	void __fastcall SetMMHeight(int Value);
	void __fastcall SetMMWidth(int Value);
	void __fastcall UniqueImage(void);
	
protected:
	virtual bool __fastcall GetEmpty(void);
	virtual int __fastcall GetHeight(void);
	virtual HPALETTE __fastcall GetPalette(void);
	virtual int __fastcall GetWidth(void);
	virtual void __fastcall Draw(TCanvas* ACanvas, const Types::TRect &Rect);
	virtual void __fastcall ReadData(Classes::TStream* Stream);
	void __fastcall ReadEMFStream(Classes::TStream* Stream);
	void __fastcall ReadWMFStream(Classes::TStream* Stream, int Length);
	virtual void __fastcall SetHeight(int Value);
	virtual void __fastcall SetTransparent(bool Value);
	virtual void __fastcall SetWidth(int Value);
	bool __fastcall TestEMF(Classes::TStream* Stream);
	virtual void __fastcall WriteData(Classes::TStream* Stream);
	void __fastcall WriteEMFStream(Classes::TStream* Stream);
	void __fastcall WriteWMFStream(Classes::TStream* Stream);
	
public:
	__fastcall virtual TMetafile(void);
	__fastcall virtual ~TMetafile(void);
	void __fastcall Clear(void);
	bool __fastcall HandleAllocated(void);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToFile(const AnsiString Filename);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall LoadFromClipboardFormat(Word AFormat, unsigned AData, HPALETTE APalette);
	virtual void __fastcall SaveToClipboardFormat(Word &AFormat, unsigned &AData, HPALETTE &APalette);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	unsigned __fastcall ReleaseHandle(void);
	virtual void __fastcall SetSize(int AWidth, int AHeight);
	__property AnsiString CreatedBy = {read=GetAuthor};
	__property AnsiString Description = {read=GetDesc};
	__property bool Enhanced = {read=FEnhanced, write=FEnhanced, default=1};
	__property unsigned Handle = {read=GetHandle, write=SetHandle, nodefault};
	__property int MMWidth = {read=GetMMWidth, write=SetMMWidth, nodefault};
	__property int MMHeight = {read=GetMMHeight, write=SetMMHeight, nodefault};
	__property Word Inch = {read=GetInch, write=SetInch, nodefault};
};


class DELPHICLASS TIconImage;
class PASCALIMPLEMENTATION TIconImage : public TSharedImage 
{
	typedef TSharedImage inherited;
	
private:
	HICON FHandle;
	Classes::TCustomMemoryStream* FMemoryImage;
	#pragma pack(push,1)
	Types::TPoint FSize;
	#pragma pack(pop)
	
protected:
	virtual void __fastcall FreeHandle(void);
	
public:
	__fastcall virtual ~TIconImage(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TIconImage(void) : TSharedImage() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TIcon : public TGraphic 
{
	typedef TGraphic inherited;
	
private:
	TIconImage* FImage;
	#pragma pack(push,1)
	Types::TPoint FRequestedSize;
	#pragma pack(pop)
	HICON __fastcall GetHandle(void);
	void __fastcall HandleNeeded(void);
	void __fastcall ImageNeeded(void);
	void __fastcall NewImage(HICON NewHandle, Classes::TMemoryStream* NewImage);
	void __fastcall SetHandle(HICON Value);
	
protected:
	virtual void __fastcall Draw(TCanvas* ACanvas, const Types::TRect &Rect);
	virtual bool __fastcall GetEmpty(void);
	virtual int __fastcall GetHeight(void);
	virtual int __fastcall GetWidth(void);
	virtual void __fastcall SetHeight(int Value);
	virtual void __fastcall SetTransparent(bool Value);
	virtual void __fastcall SetWidth(int Value);
	
public:
	__fastcall virtual TIcon(void);
	__fastcall virtual ~TIcon(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall HandleAllocated(void);
	virtual void __fastcall LoadFromClipboardFormat(Word AFormat, unsigned AData, HPALETTE APalette);
	void __fastcall LoadFromResourceName(unsigned Instance, const AnsiString ResName);
	void __fastcall LoadFromResourceID(unsigned Instance, int ResID);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	HICON __fastcall ReleaseHandle(void);
	virtual void __fastcall SaveToClipboardFormat(Word &Format, unsigned &Data, HPALETTE &APalette);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SetSize(int AWidth, int AHeight);
	__property HICON Handle = {read=GetHandle, write=SetHandle, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
static const unsigned clSystemColor = 0xff000000;
static const TColor clScrollBar = -16777216;
static const TColor clBackground = -16777215;
static const TColor clActiveCaption = -16777214;
static const TColor clInactiveCaption = -16777213;
static const TColor clMenu = -16777212;
static const TColor clWindow = -16777211;
static const TColor clWindowFrame = -16777210;
static const TColor clMenuText = -16777209;
static const TColor clWindowText = -16777208;
static const TColor clCaptionText = -16777207;
static const TColor clActiveBorder = -16777206;
static const TColor clInactiveBorder = -16777205;
static const TColor clAppWorkSpace = -16777204;
static const TColor clHighlight = -16777203;
static const TColor clHighlightText = -16777202;
static const TColor clBtnFace = -16777201;
static const TColor clBtnShadow = -16777200;
static const TColor clGrayText = -16777199;
static const TColor clBtnText = -16777198;
static const TColor clInactiveCaptionText = -16777197;
static const TColor clBtnHighlight = -16777196;
static const TColor cl3DDkShadow = -16777195;
static const TColor cl3DLight = -16777194;
static const TColor clInfoText = -16777193;
static const TColor clInfoBk = -16777192;
static const TColor clHotLight = -16777190;
static const TColor clGradientActiveCaption = -16777189;
static const TColor clGradientInactiveCaption = -16777188;
static const TColor clMenuHighlight = -16777187;
static const TColor clMenuBar = -16777186;
static const TColor clBlack = 0;
static const TColor clMaroon = 128;
static const TColor clGreen = 32768;
static const TColor clOlive = 32896;
static const TColor clNavy = 8388608;
static const TColor clPurple = 8388736;
static const TColor clTeal = 8421376;
static const TColor clGray = 8421504;
static const TColor clSilver = 12632256;
static const TColor clRed = 255;
static const TColor clLime = 65280;
static const TColor clYellow = 65535;
static const TColor clBlue = 16711680;
static const TColor clFuchsia = 16711935;
static const TColor clAqua = 16776960;
static const TColor clLtGray = 12632256;
static const TColor clDkGray = 8421504;
static const TColor clWhite = 16777215;
static const Shortint StandardColorsCount = 0x10;
static const TColor clMoneyGreen = 12639424;
static const TColor clSkyBlue = 15780518;
static const TColor clCream = 15793151;
static const TColor clMedGray = 10789024;
static const Shortint ExtendedColorsCount = 0x4;
static const TColor clNone = 536870911;
static const TColor clDefault = 536870912;
static const int clWebSnow = 0xfafaff;
static const int clWebFloralWhite = 0xf0faff;
static const int clWebLavenderBlush = 0xf5f0ff;
static const int clWebOldLace = 0xe6f5fd;
static const int clWebIvory = 0xf0ffff;
static const int clWebCornSilk = 0xdcf8ff;
static const int clWebBeige = 0xdcf5f5;
static const int clWebAntiqueWhite = 0xd7ebfa;
static const int clWebWheat = 0xb3def5;
static const int clWebAliceBlue = 0xfff8f0;
static const int clWebGhostWhite = 0xfff8f8;
static const int clWebLavender = 0xfae6e6;
static const int clWebSeashell = 0xeef5ff;
static const int clWebLightYellow = 0xe0ffff;
static const int clWebPapayaWhip = 0xd5efff;
static const int clWebNavajoWhite = 0xaddeff;
static const int clWebMoccasin = 0xb5e4ff;
static const int clWebBurlywood = 0x87b8de;
static const int clWebAzure = 0xfffff0;
static const int clWebMintcream = 0xfafff5;
static const int clWebHoneydew = 0xf0fff0;
static const int clWebLinen = 0xe6f0fa;
static const int clWebLemonChiffon = 0xcdfaff;
static const int clWebBlanchedAlmond = 0xcdebff;
static const int clWebBisque = 0xc4e4ff;
static const int clWebPeachPuff = 0xb9daff;
static const int clWebTan = 0x8cb4d2;
static const Word clWebYellow = 0xffff;
static const Word clWebDarkOrange = 0x8cff;
static const Byte clWebRed = 0xff;
static const Byte clWebDarkRed = 0x8b;
static const Byte clWebMaroon = 0x80;
static const int clWebIndianRed = 0x5c5ccd;
static const int clWebSalmon = 0x7280fa;
static const int clWebCoral = 0x507fff;
static const Word clWebGold = 0xd7ff;
static const int clWebTomato = 0x4763ff;
static const int clWebCrimson = 0x3c14dc;
static const int clWebBrown = 0x2a2aa5;
static const int clWebChocolate = 0x1e69d2;
static const int clWebSandyBrown = 0x60a4f4;
static const int clWebLightSalmon = 0x7aa0ff;
static const int clWebLightCoral = 0x8080f0;
static const Word clWebOrange = 0xa5ff;
static const Word clWebOrangeRed = 0x45ff;
static const int clWebFirebrick = 0x2222b2;
static const int clWebSaddleBrown = 0x13458b;
static const int clWebSienna = 0x2d52a0;
static const int clWebPeru = 0x3f85cd;
static const int clWebDarkSalmon = 0x7a96e9;
static const int clWebRosyBrown = 0x8f8fbc;
static const int clWebPaleGoldenrod = 0xaae8ee;
static const int clWebLightGoldenrodYellow = 0xd2fafa;
static const Word clWebOlive = 0x8080;
static const int clWebForestGreen = 0x228b22;
static const int clWebGreenYellow = 0x2fffad;
static const Word clWebChartreuse = 0xff7f;
static const int clWebLightGreen = 0x90ee90;
static const int clWebAquamarine = 0xd4ff7f;
static const int clWebSeaGreen = 0x578b2e;
static const int clWebGoldenRod = 0x20a5da;
static const int clWebKhaki = 0x8ce6f0;
static const int clWebOliveDrab = 0x238e6b;
static const Word clWebGreen = 0x8000;
static const int clWebYellowGreen = 0x32cd9a;
static const Word clWebLawnGreen = 0xfc7c;
static const int clWebPaleGreen = 0x98fb98;
static const int clWebMediumAquamarine = 0xaacd66;
static const int clWebMediumSeaGreen = 0x71b33c;
static const int clWebDarkGoldenRod = 0xb86b8;
static const int clWebDarkKhaki = 0x6bb7bd;
static const int clWebDarkOliveGreen = 0x2f6b55;
static const Word clWebDarkgreen = 0x6400;
static const int clWebLimeGreen = 0x32cd32;
static const Word clWebLime = 0xff00;
static const int clWebSpringGreen = 0x7fff00;
static const int clWebMediumSpringGreen = 0x9afa00;
static const int clWebDarkSeaGreen = 0x8fbc8f;
static const int clWebLightSeaGreen = 0xaab220;
static const int clWebPaleTurquoise = 0xeeeeaf;
static const int clWebLightCyan = 0xffffe0;
static const int clWebLightBlue = 0xe6d8ad;
static const int clWebLightSkyBlue = 0xface87;
static const int clWebCornFlowerBlue = 0xed9564;
static const int clWebDarkBlue = 0x8b0000;
static const int clWebIndigo = 0x82004b;
static const int clWebMediumTurquoise = 0xccd148;
static const int clWebTurquoise = 0xd0e040;
static const int clWebCyan = 0xffff00;
static const int clWebAqua = 0xffff00;
static const int clWebPowderBlue = 0xe6e0b0;
static const int clWebSkyBlue = 0xebce87;
static const int clWebRoyalBlue = 0xe16941;
static const int clWebMediumBlue = 0xcd0000;
static const int clWebMidnightBlue = 0x701919;
static const int clWebDarkTurquoise = 0xd1ce00;
static const int clWebCadetBlue = 0xa09e5f;
static const int clWebDarkCyan = 0x8b8b00;
static const int clWebTeal = 0x808000;
static const int clWebDeepskyBlue = 0xffbf00;
static const int clWebDodgerBlue = 0xff901e;
static const int clWebBlue = 0xff0000;
static const int clWebNavy = 0x800000;
static const int clWebDarkViolet = 0xd30094;
static const int clWebDarkOrchid = 0xcc3299;
static const int clWebMagenta = 0xff00ff;
static const int clWebFuchsia = 0xff00ff;
static const int clWebDarkMagenta = 0x8b008b;
static const int clWebMediumVioletRed = 0x8515c7;
static const int clWebPaleVioletRed = 0x9370db;
static const int clWebBlueViolet = 0xe22b8a;
static const int clWebMediumOrchid = 0xd355ba;
static const int clWebMediumPurple = 0xdb7093;
static const int clWebPurple = 0x800080;
static const int clWebDeepPink = 0x9314ff;
static const int clWebLightPink = 0xc1b6ff;
static const int clWebViolet = 0xee82ee;
static const int clWebOrchid = 0xd670da;
static const int clWebPlum = 0xdda0dd;
static const int clWebThistle = 0xd8bfd8;
static const int clWebHotPink = 0xb469ff;
static const int clWebPink = 0xcbc0ff;
static const int clWebLightSteelBlue = 0xdec4b0;
static const int clWebMediumSlateBlue = 0xee687b;
static const int clWebLightSlateGray = 0x998877;
static const int clWebWhite = 0xffffff;
static const int clWebLightgrey = 0xd3d3d3;
static const int clWebGray = 0x808080;
static const int clWebSteelBlue = 0xb48246;
static const int clWebSlateBlue = 0xcd5a6a;
static const int clWebSlateGray = 0x908070;
static const int clWebWhiteSmoke = 0xf5f5f5;
static const int clWebSilver = 0xc0c0c0;
static const int clWebDimGray = 0x696969;
static const int clWebMistyRose = 0xe1e4ff;
static const int clWebDarkSlateBlue = 0x8b3d48;
static const int clWebDarkSlategray = 0x4f4f2f;
static const int clWebGainsboro = 0xdcdcdc;
static const int clWebDarkGray = 0xa9a9a9;
static const Shortint clWebBlack = 0x0;
static const Byte WebColorsCount = 0x8c;
static const Shortint cmBlackness = 0x42;
static const int cmDstInvert = 0x550009;
static const int cmMergeCopy = 0xc000ca;
static const int cmMergePaint = 0xbb0226;
static const int cmNotSrcCopy = 0x330008;
static const int cmNotSrcErase = 0x1100a6;
static const int cmPatCopy = 0xf00021;
static const int cmPatInvert = 0x5a0049;
static const int cmPatPaint = 0xfb0a09;
static const int cmSrcAnd = 0x8800c6;
static const int cmSrcCopy = 0xcc0020;
static const int cmSrcErase = 0x440328;
static const int cmSrcInvert = 0x660046;
static const int cmSrcPaint = 0xee0086;
static const int cmWhiteness = 0xff0062;
static const Shortint rc3_StockIcon = 0x0;
static const Shortint rc3_Icon = 0x1;
static const Shortint rc3_Cursor = 0x2;
extern PACKAGE TFontData DefFontData;
extern PACKAGE HPALETTE SystemPalette16;
extern PACKAGE bool DDBsOnly;
extern PACKAGE void __fastcall PaletteChanged(void);
extern PACKAGE int __fastcall ColorToRGB(TColor Color);
extern PACKAGE AnsiString __fastcall ColorToString(TColor Color);
extern PACKAGE TColor __fastcall StringToColor(const AnsiString S);
extern PACKAGE void __fastcall GetColorValues(Classes::TGetStrProc Proc);
extern PACKAGE bool __fastcall ColorToIdent(int Color, AnsiString &Ident);
extern PACKAGE bool __fastcall IdentToColor(const AnsiString Ident, int &Color);
extern PACKAGE void __fastcall GetCharsetValues(Classes::TGetStrProc Proc);
extern PACKAGE bool __fastcall CharsetToIdent(int Charset, AnsiString &Ident);
extern PACKAGE bool __fastcall IdentToCharset(const AnsiString Ident, int &Charset);
extern PACKAGE int __fastcall BytesPerScanline(int PixelsPerScanline, int BitsPerPixel, int Alignment);
extern PACKAGE bool __fastcall TransparentStretchBlt(HDC DstDC, int DstX, int DstY, int DstW, int DstH, HDC SrcDC, int SrcX, int SrcY, int SrcW, int SrcH, HDC MaskDC, int MaskX, int MaskY);
extern PACKAGE void __fastcall GetDIBSizes(HBITMAP Bitmap, unsigned &InfoHeaderSize, unsigned &ImageSize);
extern PACKAGE bool __fastcall GetDIB(HBITMAP Bitmap, HPALETTE Palette, void *BitmapInfo, void *Bits);
extern PACKAGE void __fastcall FreeMemoryContexts(void);
extern PACKAGE HBITMAP __fastcall CreateMappedBmp(HBITMAP Handle, TColor const * OldColors, const int OldColors_Size, TColor const * NewColors, const int NewColors_Size);
extern PACKAGE HBITMAP __fastcall CreateMappedRes(unsigned Instance, char * ResName, TColor const * OldColors, const int OldColors_Size, TColor const * NewColors, const int NewColors_Size);
extern PACKAGE HBITMAP __fastcall CreateGrayMappedBmp(HBITMAP Handle);
extern PACKAGE HBITMAP __fastcall CreateGrayMappedRes(unsigned Instance, char * ResName);
extern PACKAGE HPALETTE __fastcall CopyPalette(HPALETTE Palette);
extern PACKAGE AnsiString __fastcall GraphicFilter(TMetaClass* GraphicClass);
extern PACKAGE AnsiString __fastcall GraphicExtension(TMetaClass* GraphicClass);
extern PACKAGE AnsiString __fastcall GraphicFileMask(TMetaClass* GraphicClass);
extern PACKAGE TFontCharset __fastcall GetDefFontCharSet(void);
extern PACKAGE TBitmap* __fastcall AllocPatternBitmap(TColor BkColor, TColor FgColor);

}	/* namespace Graphics */
using namespace Graphics;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Graphics
